package jamezo97.clonecraft.gui;

import org.lwjgl.opengl.GL11;

import jamezo97.clonecraft.block.TileEntityLifeInducer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;

public class GuiLifeInducer extends GuiContainer{

	TileEntityLifeInducer tileEntity;
	
	public GuiLifeInducer(InventoryPlayer playerInven, TileEntityLifeInducer tileEntity) {
		super(new ContainerLifeInducer(playerInven, tileEntity));
		this.tileEntity = tileEntity;
		xSize = 176;
		ySize = 190;
	}
	
	

	@Override
	protected void drawGuiContainerForegroundLayer(int par1, int par2) {
		
	}


	float alpha = 1.0f;
	
	double rad = 0;

	@Override
	public void updateScreen() {
		super.updateScreen();
		rad += ((double)tileEntity.storedPower)/1600.0d * Math.PI * 2.0d;
		if(rad > Math.PI * 2){
			rad = rad % (Math.PI*2.0d);
		}
		alpha = (float)((Math.cos(rad) + 1.0)/2.0);
	}



	@Override
	protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
		GL11.glPushMatrix();
		mc.getTextureManager().bindTexture(guiImage);
		int xStart = (width - xSize)/2;
		int yStart = (height - ySize)/2;
		
		drawTexturedModalRect(xStart, yStart, 0, 0, xSize, ySize);
		drawTexturedModalRect(xStart+8, yStart+7, 0, 200, tileEntity.storedPower, 16);
		if(tileEntity.storedPower > 0){
			GL11.glEnable(GL11.GL_BLEND);
		    GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
			GL11.glColor4f(1.0f, 1.0f, 1.0f, alpha);
			drawTexturedModalRect(xStart+15, yStart+24, 0, 190, 146, 10);
		    
			GL11.glDisable(GL11.GL_BLEND);
		}
		GL11.glPopMatrix();
	}
	
	
	public static final ResourceLocation guiImage = new ResourceLocation("CloneCraft:textures/gui/transmogrifier.png");

}
